/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.sdgraph;

import cz.insophy.inplan.mrp.CustomerRequest;
import cz.insophy.inplan.property.PropertyDefinition;
import cz.insophy.inplan.sdgraph.StoreDependencyGraphBuilder;
import cz.insophy.inplan.shop.ShopConfiguration;
import cz.insophy.inplan.store.StoreActivity;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.ProductionTreeAlgorithms;
import cz.insophy.inplan.superplan.ProductionTreeNode;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.util.Comparators;
import cz.insophy.inplan.util.Identifiable;
import java.util.Comparator;
import javax.annotation.Nonnull;

public class SaComparators {

    static final class SaComparator
    implements Comparator<StoreActivity> {
        private final PropertyDefinition pullOrderPd;

        SaComparator(Superplan superplan) {
            ShopConfiguration conf = superplan.getShopConf();
            this.pullOrderPd = conf.getPropertyDefinition(GeneralizedActionRequest.class, "pullOrder");
        }

        private long getPullOrder(StoreActivity sa) {
            Object orig = sa.getOriginator();
            if (this.pullOrderPd != null && orig instanceof GeneralizedActionRequest) {
                Long pull = (Long)((GeneralizedActionRequest)orig).getProperty(this.pullOrderPd);
                return pull == null ? Long.MAX_VALUE : pull;
            }
            if (orig instanceof CustomerRequest) {
                return Long.MIN_VALUE;
            }
            return Long.MAX_VALUE;
        }

        private static String getId(StoreActivity sa) {
            Object orig = sa.getOriginator();
            if (orig instanceof Identifiable) {
                if (orig instanceof ProductionTreeNode) {
                    return ProductionTreeAlgorithms.getNearestGor((ProductionTreeNode)orig).getId();
                }
                return ((Identifiable)orig).getId();
            }
            return "";
        }

        @Override
        public int compare(StoreActivity sa1, StoreActivity sa2) {
            int cmp = Long.compare(sa1.getTime(), sa2.getTime());
            if (cmp != 0) {
                return cmp;
            }
            cmp = Long.compare(this.getPullOrder(sa1), this.getPullOrder(sa2));
            if (cmp != 0) {
                return cmp;
            }
            cmp = Double.compare(sa1.getAbsQty(), sa2.getAbsQty());
            if (cmp != 0) {
                return cmp;
            }
            cmp = SaComparator.getId(sa1).compareTo(SaComparator.getId(sa2));
            return cmp;
        }
    }

    static class PriorityFifoSaComparator
    implements Comparator<StoreActivity> {
        private final boolean usePriority;
        private final StoreDependencyGraphBuilder.NodeMode nodeMode;

        PriorityFifoSaComparator(boolean usePriority, StoreDependencyGraphBuilder.NodeMode nodeMode) {
            this.usePriority = usePriority;
            this.nodeMode = nodeMode;
        }

        private static int getPriority(StoreActivity sa) {
            Object orig = sa.getOriginator();
            if (orig instanceof ProductionTreeNode) {
                return Integer.MAX_VALUE;
            }
            if (orig instanceof CustomerRequest) {
                return ((CustomerRequest)orig).getPriority();
            }
            return Integer.MIN_VALUE;
        }

        @Nonnull
        private String getId(StoreActivity sa) {
            Object orig = sa.getOriginator();
            if (orig instanceof Identifiable) {
                if (orig instanceof ProductionTreeNode) {
                    switch (this.nodeMode) {
                        case GAR: {
                            return "";
                        }
                        case GOR: {
                            return ProductionTreeAlgorithms.getNearestGor((ProductionTreeNode)orig).getId();
                        }
                    }
                } else {
                    return ((Identifiable)orig).getId();
                }
            }
            return "";
        }

        @Override
        public int compare(StoreActivity o1, StoreActivity o2) {
            int cmp;
            if (this.usePriority && (cmp = Comparators.compare(PriorityFifoSaComparator.getPriority(o1), PriorityFifoSaComparator.getPriority(o2))) != 0) {
                return cmp;
            }
            cmp = Comparators.compare(o1.getTime(), o2.getTime());
            if (cmp != 0) {
                return cmp;
            }
            cmp = Double.compare(o1.getAbsQty(), o2.getAbsQty());
            if (cmp != 0) {
                return cmp;
            }
            return this.getId(o1).compareTo(this.getId(o2));
        }
    }
}

